#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// asymmetric blocks dda pluginMod01.fsh   by  jt  
//https://www.shadertoy.com/view/Dd3BDs
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// https://www.shadertoy.com/view/Dd3BDs asymmetric blocks dda plugin, 2023 by jt
// modified https://www.shadertoy.com/view/dd3fDj raymarch voxels
// to snap to https://www.shadertoy.com/view/dstfzf asymmetric blocks compactified float

// Proof-of-concept:
// Modified the DDA-plugin (https://www.shadertoy.com/view/dd3fDj raymarch voxels)
// to snap to https://www.shadertoy.com/view/dstfzf asymmetric blocks compactified float
// INSIDE of tile instead of at voxel boundaries.

// A previous approach just applied the asymmetric blocks pattern to mark voxel type:
// https://www.shadertoy.com/view/msdfD2 asymmetric blocks voxel city 

// Thanks to Shane for suggesting the DDA-plugin / snap-to-voxel method!

// tags: 3d, raymarch, voxels, sdf, random, distance, field, dda, hybrid, skip, signed, indexed, discontinuous, plugin, sparse, robust

// The MIT License
// Copyright (c) 2023 Jakob Thomsen
// Permission is hereby granted, free of charge, to any person obtaining a copy of this software and associated documentation files (the "Software"), to deal in the Software without restriction, including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, subject to the following conditions: The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software. THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

// For correct ambient occlusion sample 2x2x2 voxels (slow!)
//#define HIGH_QUALITY

float hash12(vec2 p) // https://www.shadertoy.com/view/4djSRW Hash without Sine by Dave_Hoskins
{
	vec3 p3  = fract(vec3(p.xyx) * .1031);
    p3 += dot(p3, p3.yzx + 33.33);
    return fract((p3.x + p3.y) * p3.z);
}

vec2 hash22(vec2 p) // https://www.shadertoy.com/view/4djSRW Hash without Sine by Dave_Hoskins
{
	vec3 p3 = fract(vec3(p.xyx) * vec3(.1031, .1030, .0973));
    p3 += dot(p3, p3.yzx+33.33);
    return fract((p3.xx+p3.yz)*p3.zy);
}

vec3 hash32(vec2 p) // https://www.shadertoy.com/view/4djSRW Hash without Sine by Dave_Hoskins
{
	vec3 p3 = fract(vec3(p.xyx) * vec3(.1031, .1030, .0973));
    p3 += dot(p3, p3.yxz+33.33);
    return fract((p3.xxy+p3.yzz)*p3.zyx);
}
/*
vec3 hash33(vec3 p3) // https://www.shadertoy.com/view/4djSRW Hash without Sine by Dave_Hoskins
{
	p3 = fract(p3 * vec3(.1031, .1030, .0973));
    p3 += dot(p3, p3.yxz+33.33);
    return fract((p3.xxy + p3.yxx)*p3.zyx);
}
*/
struct block
{
    vec4 minmax;
    ivec2 id;
};

float block_hash(ivec2 t, int x, int y, bool choose, bool mirror)
{
    ivec2 d = (mirror?ivec2(y, x):ivec2(x, y));
    vec2 r = fract(hash22(vec2(t+d)))+vec2(d); // float hash
    return choose?r.y:r.x;
}

// Inspired by https://www.shadertoy.com/view/Ws3GRs Asymmetric Blocks by Shane,
// and also by https://www.shadertoy.com/view/tsVGRz Oddtiles (optimized) by stb.
// Checkerboard tiling of alternating (horizontal vs. vertical) (double-T-) crossings.
// Returns minimum, maximum, id.
// Compactified using implicit matrix transpose & deferred hash calls.
//(NOTE: inlining the hash-function and using out parameters instead of block structure
//       could be used to turn this into a stand-alone function.)
block blocks_layout(ivec2 tile, vec2 local) // https://www.shadertoy.com/view/dstfzf asymmetric blocks compactified f by jt
{
    //bool flip = (tile.x % 2) != (tile.y % 2); // XXX breaks on windows XXX
    bool flip = (tile.x & 1) != (tile.y & 1); // alternate direction of double T crossings: vertical or horizontal
    //flip = !flip; // "dual" pattern (i.e. T-crossings flipped)
    
    // layout (NOTE: matrix notation upside down compared to coordinate system!)
    // NW N NE
    //  W C E
    // SW S SE
       
    // transposed (NOTE: matrix notation upside down compared to coordinate system!)
    // SE W NE
    //  N C S
    // SW E NW
    
    if(flip) // horizontal line goes through: swap vertical with horizontal
    {
        // swap components
        local = local.yx;
    }

    // vertical line goes through (on flip transpose for horizontal line)

    //                 c
    //   +-+---------+---+-------+
    //   | |         |   |       |
    //   | |         |   #-------+ d
    // d +-#-#-------+---M       |
    //   |   |       |   |       |
    //   +---+-------+---+-------+
    //   |   |       |   |       |
    //   |   m-------+---#---#---+
    //   +---#       |       |   |
    //   |   |       |       |   |
    //   +---+-------+-------+---+

    float c = block_hash(tile, 0, 0,  flip, flip); // offset of central line
    int x = 1-int(local.x < c); // [0,1]
    int X = 2*x-1; // [-1,+1]
    float d = block_hash(tile, X, 0, !flip, flip); // offset of branching line
    int y = 1-int(local.y < d); // [0,1]
    int Y = 2*y-1; // [-1,+1]

    vec4 minmax =
        vec4
        (
            // block corner in central tile
            c,
            d,
            // block corner in (X,Y) tile
            block_hash(tile, X, Y,  flip, flip),
            block_hash(tile, 0, Y, !flip, flip)
        );

    if(flip) tile = tile.yx;

    minmax += vec2(tile).xyxy;

    ivec2 id = tile + ivec2(x,y);

    if(flip) // horizontal line goes through: unswap vertical with horizontal
    {
        minmax = minmax.yxwz;
        id = id.yx;
    }

    // fix order of min/max corners
    vec2 center = (minmax.xy+minmax.zw)/2.0;
    vec2 extent = abs(minmax.xy-minmax.zw)/2.0;
    
    minmax.xy = center-extent;
    minmax.zw = center+extent;
    
    return block(minmax, id);
}

#define pi 3.1415926

mat3 yaw_pitch_roll(float yaw, float pitch, float roll)
{
    mat3 R = mat3(vec3(cos(yaw), sin(yaw), 0.0), vec3(-sin(yaw), cos(yaw), 0.0), vec3(0.0, 0.0, 1.0));
    mat3 S = mat3(vec3(1.0, 0.0, 0.0), vec3(0.0, cos(pitch), sin(pitch)), vec3(0.0, -sin(pitch), cos(pitch)));
    mat3 T = mat3(vec3(cos(roll), 0.0, sin(roll)), vec3(0.0, 1.0, 0.0), vec3(-sin(roll), 0.0, cos(roll)));

    return R * S * T;
}

float halfspace(vec3 p)
{
    return p.z + 1.0;
}

float sphere(vec3 p, float r)
{
    return length(p) - r;
}

float box(vec2 p, vec2 s) // adapted from https://iquilezles.org/articles/distfunctions/
{
    vec2 d = abs(p) - s;
    return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

float box(vec3 p, vec3 s) // adapted from https://iquilezles.org/articles/distfunctions/
{
    vec3 d = abs(p) - s;
    return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float box(vec3 p, vec3 p0, vec3 p1)
{
    return box(p-(p1+p0)/2.0, (p1-p0)/2.0);
}

float box(vec2 p, vec2 p0, vec2 p1, float r) // min-max box with rounded corner
{
    return box(p-(p1+p0)/2.0, (p1-p0)/2.0-r)-r;
}

float box(vec3 p, vec3 p0, vec3 p1, float r) // min-max box with rounded corner
{
    float d = box(p.xy, p0.xy, p1.xy, r);
    vec2 w = vec2(d, abs(p.z-(p1.z+p0.z)/2.0) - (p1.z-p0.z)/2.0);
    return min(max(w.x,w.y),0.0) + length(max(w,0.0));
}

float cylinder(vec3 p, vec2 s) // adapted from https://iquilezles.org/articles/distfunctions/
{
    vec2 d = abs(vec2(length(p.xy),p.z)) - s;
    return min(max(d.x,d.y),0.0) + length(max(d,0.0));
}

#define EPSILON 0.001
#define DIST_MAX 50.0
#define ITER_MAX 200u

struct result
{
    float dist;
    vec3 color;
};

result map(ivec3 v, vec3 l) // unit grid: voxel = float(position), local = fract(position)
{
    block b = blocks_layout(v.xy, l.xy);
    vec2 rnd = hash22(vec2(b.id));
    float h = 3.0 * rnd.x;
    float r = mix(0.0, 0.2, rnd.y);
    float d = box(vec3(v)+l, vec3(b.minmax.xy+0.1,0), vec3(b.minmax.zw-0.1,h), r);
    float e = float(v.z)+l.z; // floor
    
    if(d < e)
        return result(d, hash32(vec2(b.id)));

    return result(e, vec3(1));
}
#ifdef HIGH_QUALITY
result map(vec3 p) // for correct ambient occlusion sample 2x2x2 voxels (slow!)
{
    // I think kastorp originally suggested to sample only 2x2x2 instead of 3x3x3, thanks!
    result d = result(DIST_MAX, vec3(0));
    ivec3 s = ivec3(step(0.5, fract(p)));
    ivec3 o;
    for(o.z = s.z-1; o.z < s.z+1; o.z++)
        for(o.y = s.y-1; o.y < s.y+1; o.y++)
            for(o.x = s.x-1; o.x < s.x+1; o.x++)
            {
                result r = map(ivec3(floor(p))+o, fract(p)-vec3(o));
                if(r.dist < d.dist)
                    d = r;
            }
    return d;
}
#else
result map(vec3 p)
{
    return map(ivec3(floor(p)), fract(p));
}
#endif
// https://iquilezles.org/articles/normalsSDF tetrahedron normals
vec3 normal(vec3 p)
{
    const float h = EPSILON;
    const vec2 k = vec2(1,-1);
    return normalize(k.xyy*map(p + k.xyy*h).dist +
                     k.yyx*map(p + k.yyx*h).dist +
                     k.yxy*map(p + k.yxy*h).dist +
                     k.xxx*map(p + k.xxx*h).dist);
}

// NOTE: Apparently sign fails on some systems! Thanks to spalmer for debugging this!
vec2 sgn(vec2 v) // WORKAROUND FOR COMPILER ERROR on some systems
{
    return step(vec2(0), v) * 2.0 - 1.0;
}

result trace(vec3 ro, vec3 rd, float t0, float t1) // ray-march sdf handling discontinuities between voxels  (jt)
{
    uint i;
    float t;
    for(t = t0, i = 0u; t < t1 && i < ITER_MAX; i++) // finite loop originally suggested by pyBlob to avoid stalling if ray parallel to surface just above EPSILON
    {
        vec3 p = ro + rd * t;
        result h = map(p);
        if(h.dist < EPSILON)
            return result(t, h.color);

        // NOTE: An extra step per block, use if sdf discontinuous between blocks
        //       Could make this conditional by prefixing sth. like if(block_changed) // suggested by spalmer
        // constrain step to blocks (voxel-snap ray-march plugin by jt, thanks to Shane for the idea!)
        {
            block b = blocks_layout(ivec2(floor(p.xy)), fract(p.xy));
            vec2 c = (b.minmax.zw+b.minmax.xy)/2.0-floor(p.xy); // center
            vec2 e = (b.minmax.zw-b.minmax.xy)/2.0; // extent
            // NOTE: assuming unit grid
            // sgn(rd)*e are the block walls in ray direction, fract(p) - c is position relative to center of block
            vec2 sd = (sgn(rd.xy)*e - (fract(p.xy) - c))/rd.xy; // distances to block sides / walls
            vec2 n = step(sd.xy, sd.yx); // component true if corresponding wall is nearest (at most one component true) NOTE: originally I used lessThanEqual, min from fb39ca4/kzy then switched to step, min by iq
            float skip = dot(sd, n) + EPSILON; // distance to next block: sum up all components, weighted by the nearest flag (assuming only one component is true this selects the nearest component)
            h.dist = min(h.dist, skip); // constrain step to at most next block to handle sdf discontinuities between voxels
        }

        t += h.dist;
    }

    return result(t, vec3(0)); // pass on running out of iterations
}

// NOTE: Don't forget to add +normal*EPSILON to the starting position
//       to avoid artifacts caused by getting stuck in the surface
//       due to starting at distance < EPSILON from the surface.
//       (normal could be calculated here but that would most likely be redundant)
//       Thanks to spalmer for pointing that out.
float shadow(vec3 ro, vec3 rd, float t0, float t1)
{
    return trace(ro, rd, t0, t1).dist < t1 ? 0.0 : 1.0;
}

// https://iquilezles.org/articles/rmshadows
float softshadow(vec3 ro, in vec3 rd, float t0, float t1, float k)
{
    float res = 1.0;
    float ph = 1e20;
    uint i;
    float t;
    for(t = t0, i = 0u; t < t1 && i < ITER_MAX; i++)
    {
        float h = map(ro + rd*t).dist;
        if( h < EPSILON )
            return 0.0;
        float y = h*h/(2.0*ph);
        float d = sqrt(h*h-y*y);
        res = min( res, k*d/max(0.0,t-y) );
        ph = h;
        t += h;
    }
    return res;
}

// https://www.shadertoy.com/view/Xds3zN raymarching primitives
float calcAO( in vec3 pos, in vec3 nor )
{
    float occ = 0.0;
    float sca = 1.0;
    for( int i=0; i<5; i++ )
    {
        float h = 0.01 + 0.12*float(i)/4.0;
        float d = map( pos + h*nor ).dist;
        occ += (h-d)*sca;
        sca *= 0.95;
        if( occ>0.35 ) break;
    }
    return clamp( 1.0 - 3.0*occ, 0.0, 1.0 ) ;
}

float checker(vec2 p)
{
    return step(0.0, sin(p.x*pi)*sin(p.y*pi));
}

float checker(vec3 p)
{
    return step(0.0, sin(p.x*pi)*sin(p.y*pi)*sin(p.z*pi));
}

vec3 material(vec3 p)
{
    return vec3(1.0-pow(0.5+0.5*sin(p.z*pi*10.0), 50.0));
    //return vec3(1.0);
    //return mix(vec3(0.25), vec3(0.75), checker(p*2.0+0.5));
}

vec3 sky(vec3 lightdir, vec3 d)
{
    float v = 0.5*abs(d.z)+0.5;
    return vec3(pow(1.0-v,2.0),1.0-v,v); // no particular meaning - just tweaked until it looks skyish
}

float sun(vec3 lightdir, vec3 rd)
{
    float d = max(0.0, dot(rd, lightdir));
    return smoothstep(0.997, 0.998, d) + exp(-pow((1.0-d)*500.0, 2.0)); // sun with halo
}
#define I fragCoord
//void mainImage(out vec4 fragColor, vec2 I)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    bool demo = all(lessThan(iMouse.xy, vec2(10.0)));
    vec2 R = iResolution.xy;
    //R *= .5; I = floor(I * .5) + .5; // pixelize (speedup & looks cool) thanks to spalmer
    I = (2.0 * I - R) / R.y; // concise scaling thanks to Fabrice
    
    float yaw = 2.0 * pi * float(iMouse.x) / float(R.x);
    float pitch = pi - pi / 2.0 * float(iMouse.y) / float(R.y);
    yaw = !demo ? yaw : 2.0 * pi * fract(iTime * 0.01);
    pitch = !demo ? pitch : 4.0/3.0 * pi / 2.0;

    vec3 ro = vec3(0.0, 0.0,-7.5);
    vec3 rd = normalize(vec3(I.xy, 2.0));

    mat3 M = yaw_pitch_roll(yaw, pitch, 0.0);
    ro = M * ro;
    rd = M * rd;
    ro.z += 1.0;

    vec3 lightdir = normalize(vec3(3.0, 2.0, 1.0));
    
    float dim = 1.0-pow(max(0.0, dot(M * vec3(0,0,1), lightdir)), 4.0); // reduce brightness when looking towards sun to make sunlight seem brighter
    //float dim = pow(1.0-max(0.0, dot(M[2], lightdir)), 1.0); // reduce brightness when looking towards sun to make sunlight seem brighter 
    //float dim = 1.0; // disable brightness change
    
    //vec3 sky_color = mix(vec3(0.2,0.5,0.5),vec3(0,0,1),abs(-rd.z));
    //vec3 sky_color = mix(vec3(0.2,0.5,0.5),vec3(0,0,0.5),sqrt(abs(rd.z)));
    vec3 sky_color = sky(lightdir, rd);
    //vec3 color = vec3(1);
    vec3 color = vec3(dim);
    result r = trace(ro, rd, 0.0, DIST_MAX);
    if(r.dist < DIST_MAX)
    {
        color *= r.color;
        vec3 dst = ro + rd * r.dist;
        vec3 n = normal(dst);

        color *= (n * 0.5 + 0.5);
        color *= material(dst);

        vec3 ambient = vec3(0.4);
        float brightness = max(dot(lightdir, n), 0.0);
        if(brightness > 0.0)
            brightness *= shadow(ro + rd * r.dist + n * 0.01, lightdir, 0.0, DIST_MAX);
            //brightness *= softshadow(ro + rd * dist + n * 0.01, lightdir, 0.0, DIST_MAX, 20.0);
        color *= (ambient * calcAO(dst, n) + brightness);

        if(brightness > 0.0)
        {
            float specular = pow(max(0.0, dot(n, normalize(-rd + lightdir))), 250.0);
            color += specular;
        }

        //vec3 fog_color = vec3(0.2);
        vec3 fog_color = sky_color * dim;
        color = mix(fog_color, vec3(color), exp(-pow(r.dist/20.0, 2.0))); // fog
    }
    else
    {
        color *= sky_color;
    }

    color = tanh(color); // roll-off overly bright colors
    
    color = min(vec3(1.0), color + step(DIST_MAX, r.dist) * sun(lightdir, rd)); // make sure sun has maximal brightness (no roll-off here!)

    fragColor = vec4(color, 1);
    fragColor = sqrt(fragColor); // approximate gamma
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

